<?php

namespace iThemesSecurity\Site_Scanner;

final class Vulnerability implements Issue {
	use Issue_Trait;

	/** @var array */
	private $vulnerability;

	/** @var array */
	private $issue;

	/**
	 * Vulnerability constructor.
	 *
	 * @param array  $vulnerability The full vulnerability details for the software item.
	 * @param string $issue_id      The id of this particular issue.
	 * @param string $details_link  The link to more details about the issue.
	 */
	public function __construct( array $vulnerability, $issue_id, $details_link ) {
		$match = wp_list_filter( $vulnerability['issues'], [ 'id' => $issue_id ] );
		$issue = reset( $match );

		$this->id            = $issue_id;
		$this->description   = $issue['title'];
		$this->status        = Status::WARN;
		$this->link          = $details_link;
		$this->issue         = $issue;
		$this->vulnerability = $vulnerability;
		$this->entry         = 'vulnerabilities';
	}

	public function get_meta() {
		$meta = [
			'issue' => $this->issue,
			'type'  => $this->vulnerability['type'],
		];

		if ( isset( $this->vulnerability['software'] ) ) {
			$meta['software'] = $this->vulnerability['software'];
		}

		return $meta;
	}

	/**
	 * Get the version the vulnerability was fixed in.
	 *
	 * @return string|null
	 */
	public function get_fixed_in() {
		return $this->issue['fixed_in'];
	}
}
