<?php
/**
 * Define backend metabox content
 * ==============================
 * 
 */
if( ! defined( 'ABSPATH' ) ) {  exit;  }    // Exit if accessed directly

$av_default_title = __( 'Avia Layout Builder', 'avia_framework' );

if( Avia_Element_Templates()->is_edit_element_page() )
{
	$av_default_title .= Avia_Element_Templates()->alb_metabox_title();
}

if( Avia_Builder()->disable_drag_drop == true )
{
	$av_default_title = __( 'Page Layout', 'avia_framework' );
}

$alb_post_types = Avia_Builder()->get_supported_post_types();

/**
 * @since 4.5.5
 * @param array
 * @return array
 */
$layout_post_types = apply_filters( 'avf_metabox_layout_post_types', array( 'portfolio', 'page' , 'post' ) );

$boxes = array(
	
			array( 
				'title'			=> $av_default_title, 
				'id'			=>'avia_builder', 
				'page'			=> $alb_post_types, 
				'context'		=> 'normal', 
				'priority'		=> 'high', 
				'expandable'	=> true 
			),
			array( 
				'title'			=> __( 'Enfold Shortcode Parser', 'avia_framework' ), 
				'id'			=> 'avia_sc_parser', 
				'page'			=> $alb_post_types, 
				'context'		=> 'normal', 
				'priority'		=> 'high', 
				'expandable'	=> false 
			),
			array( 
				'title'			=> __( 'Layout', 'avia_framework' ), 
				'id'			=> 'layout', 
				'page'			=> $layout_post_types, 
				'context'		=> 'side', 
				'priority'		=> 'low'
			),
			array( 
				'title'			=> __( 'Additional Portfolio Settings', 'avia_framework' ), 
				'id'			=> 'preview', 
				'page'			=> array( 'portfolio' ), 
				'context'		=> 'normal', 
				'priority'		=> 'high' 
			),
			array( 
				'title'			=> __( 'Breadcrumb Hierarchy', 'avia_framework' ), 
				'id'			=> 'hierarchy', 
				'page'			=> array( 'portfolio' ), 
				'context'		=> 'side', 
				'priority'		=> 'low'
			)
		);

/**
 * @used_by:		enfold\config-woocommerce\admin-options.php  avia_woocommerce_product_options()			10
 * @used_by:		enfold\config-gutenberg\class-avia-gutenberg.php										20
 */
$boxes = apply_filters( 'avf_builder_boxes', $boxes );


$elements = array(
	
			array(
				'slug'	=> 'avia_sc_parser',
				'name'	=> __( 'Enfold Shortcode Parser Info Window', 'avia_framework' ),
				'id'	=> 'sc_parser_info',
				'type'	=> array( Avia_Builder(), 'parser_select_panel' )
			),
	
			array(
				'slug'		=> 'avia_builder',
				'name'		=> __( 'Visual layout editor', 'avia_framework' ),
				'id'		=> 'layout_editor',
				'type'		=> array( Avia_Builder(), 'visual_editor' ),
				'tab_order'	=> array( __( 'Layout Elements', 'avia_framework' ), __( 'Content Elements', 'avia_framework' ), __( 'Media Elements', 'avia_framework' ) ),
				'desc'		=> '<h4>'.__( 'Quick Info & Hotkeys', 'avia_framework' ) . '</h4>'.
								'<strong>'.__( 'General Info', 'avia_framework' ) . '</strong>' .
								'<ul>' .
								'   <li>' . __( 'To insert an Element either click the insert button for that element or drag the button onto the canvas', 'avia_framework' ) . '</li>' .
								'   <li>' . __( 'If you place your mouse above the insert button a short info tooltip will appear', 'avia_framework' ) . '</li>' .
								'   <li>' . __( 'To sort and arrange your elements just drag them to a position of your choice and release them', 'avia_framework' ) . '</li>' .
								'   <li>' . __( 'Valid drop targets will be highlighted. Some elements like fullwidth sliders and color section can not be dropped onto other elements', 'avia_framework' ) . '</li>' .
								'</ul>'.
								'<strong>' . __( 'Edit Elements in Popup Window:', 'avia_framework' ) . '</strong>' .
								'<ul>' .
								'   <li>' . __( 'Most elements open a popup window if you click them', 'avia_framework' ) . '</li>' .
								'   <li>' . __( 'Press TAB to navigate trough the various form fields of a popup window.', 'avia_framework' ) . '</li>' .
								'   <li>' . __( 'Press ESC on your keyboard or the Close Button to close popup window.', 'avia_framework' ) . '</li>' .
								'   <li>' . __( 'Press ENTER on your keyboard or the Save Button to save current state of a popup window', 'avia_framework' ) . '</li>' .
								'</ul>'
			),

			array(
				'slug'		=> 'preview',
				'name'		=> __( 'Overwrite Portfolio Link setting', 'avia_framework' ),
				'desc'		=> __( 'If this entry is displayed in a portfolio grid, it will use the grids link settings (open either in lightbox, or open link url). You may overwrite this setting here', 'avia_framework' ),
				'id'		=> '_portfolio_custom_link',
				'type'		=> 'select',
				'std'		=> '',
				'container_class' => 'av_2columns av_col_1 avia-style',
				'subtype'	=> array( 
									__( 'Use default setting', 'avia_framework' )	=> '',
									__( 'Define custom link', 'avia_framework' )	=> 'custom'								
								)
			),

			array(
				'slug'		=> 'preview',
				'name'		=> __( 'Link portfolio item to external URL', 'avia_framework' ),
				'desc'		=> __( 'You can add a link to any (external) page here.', 'avia_framework' ) .
								'<br/>' . __( 'If you add a link to a video that video will open in a lightbox ', 'avia_framework' ),
				'id'		=> '_portfolio_custom_link_url',
				'type'		=> 'input',
				'std'		=> 'http://',
				'required'	=> array( '_portfolio_custom_link', 'equals', 'custom' ),
				'container_class' => 'avia-style av_2columns av_col_2',
				),

			array(
				'slug'	=> 'preview',
				'id'	=> '_portfolio_hr',
				'type'	=> 'hr',
				'std'	=> ''
			),

			array(
				'slug'  => 'preview',
				'name'  => __( 'Ajax Portfolio Preview Settings', 'avia_framework' ),
				'desc'  => __( "If you have selected to display your portfolio grid as an 'Ajax Portfolio' please choose preview images here and write some preview text. Once the user clicks on the portfolio item a preview element with those images and info will open.", 'avia_framework' ),
				'id'    => '_preview_heading',
				'type'  => 'heading',
				'std'   => ''
			),

			array(
				'slug'		=> 'preview',
				'name'		=> __( 'Add Preview Images', 'avia_framework' ),
				'desc'		=> __( 'Create a new Preview Gallery or Slideshow by selecting existing or uploading new images', 'avia_framework' ),
				'id'		=> '_preview_ids',
				'type'		=> 'gallery',
				'title'		=> __( 'Add Preview Images', 'avia_framework' ),
				'delete'	=> __( 'Remove Images', 'avia_framework' ),
				'button'	=> __( 'Insert Images', 'avia_framework' ),
				'std'		=> '',
				'container_class' => 'av_2columns av_col_1',
			),

			array(
				'slug'		=> 'preview',
				'name'		=> __( 'Display Preview Images', 'avia_framework' ),
				'desc'		=> __( 'Display Images as either gallery, slideshow or as a list below each other', 'avia_framework' ),
				'id'		=> '_preview_display',
				'type'		=> 'select',
				'std'		=> 'gallery',
				'container_class' => 'av_2columns av_col_2',
				'class'		=> 'avia-style',
				'subtype'	=> array( 
									__( 'Gallery', 'avia_framework' )		=> 'gallery',
									__( 'Slideshow', 'avia_framework' )		=> 'slideshow',
									__( 'Image List', 'avia_framework' )	=> 'list',
									__( "Don't show the images at all and display the preview text only", 'avia_framework' ) => 'no'

								),
			),

			array(
				'slug'		=> 'preview',
				'name'		=> __('Autorotation','avia_framework'),
				'desc'		=> __('Slideshow autorotation Settings in Seconds','avia_framework'),
				'id'		=> '_preview_autorotation',
				'type'		=> 'select',
				'std'		=> 'disabled',
				'container_class' => 'av_2columns av_col_2',
				'class'		=> 'avia-style',
				'required'	=> array( '_preview_display', 'equals', 'slideshow' ),
				'subtype'	=> array(
									__( 'Disabled', 'avia_framework') => 'disabled',
									'3'		=> '3',
									'4'		=> '4',
									'5'		=> '5',
									'6'		=> '6',
									'7'		=> '7',
									'8'		=> '8',
									'9'		=> '9',
									'10'	=> '10',
									'15'	=> '15',
									'20'	=> '20'
								),
			),

			array(
				'slug'		=> 'preview',
				'name'		=> __( 'Gallery Thumbnail Columns', 'avia_framework' ),
				'desc'		=> __( 'How many Thumbnails should be displayed beside each other', 'avia_framework' ),
				'id'		=> '_preview_columns',
				'type'		=> 'select',
				'std'		=> '6',
				'container_class' => 'av_2columns av_col_2',
				'class'		=> 'avia-style',
				'required'	=> array( '_preview_display', 'equals', 'gallery' ),
				'subtype'	=> array(
									'2'		=> '2',
									'3'		=> '3',
									'4'		=> '4',
									'5'		=> '5',
									'6'		=> '6',
									'7'		=> '7',
									'8'		=> '8',
									'9'		=> '9',
									'10'	=> '10',
									'11'	=> '11',
									'12'	=> '12'
								),
			),

			array(
				'slug'		=> 'preview',
				'name'		=> __( 'Add Preview Text', 'avia_framework' ),
				'desc'		=> __( 'The text will appear beside your gallery/slideshow', 'avia_framework' ),
				'id'		=> '_preview_text',
				'type'		=> 'tiny_mce',
				'std'		=> '',
				'container_class' => 'avia_clear',
			),

			array(
				'slug'		=> 'layout',
				'name'		=> __('Sidebar Settings','avia_framework'),
				'desc'		=> __('Select the desired Page layout','avia_framework'),
				'id'		=> 'layout',
				'type'		=> 'select',
				'std'		=> '',
				'class'		=> 'avia-style',
				'subtype'	=> array( 
									__( 'Default Layout - set in', 'avia_framework' ) . ' ' . THEMENAME . ' > ' . __( 'Sidebar', 'avia_framework' ) => '',
									__( 'No Sidebar', 'avia_framework' )	=> 'fullsize',
									__( 'Left Sidebar', 'avia_framework' )	=> 'sidebar_left',
									__( 'Right Sidebar', 'avia_framework' )	=> 'sidebar_right'
								),
			),

			array(
				'slug'		=> 'layout',
				'name'		=> __( 'Sidebar Setting', 'avia_framework' ),
				'desc'		=> __( 'Choose a custom sidebar for this entry', 'avia_framework' ),
				'id'		=> 'sidebar',
				'type'		=> 'select',
				'std'		=> '',
				'class'		=> 'avia-style',
				'required'	=> array( 'layout', 'not', 'fullsize' ),
				'subtype'	=> AviaHelper::get_registered_sidebars( array( 'Default Sidebars' => '' ), array( 'Displayed Everywhere' ) )
			),
        
			/**
			  * With 4.2.7 adding 'page as footer' subtype array must be changed depending on main option settings via filter avf_builder_elements
			 */
			array(
				'slug'		=> 'layout',
				'name'		=> __( 'Footer Settings', 'avia_framework' ),
				'desc'		=> __( 'Display the footer widgets or page?', 'avia_framework' ),
				'id'		=> 'footer',
				'type'		=> 'select',
				'std'		=> '',
				'class'		=> 'avia-style',
				'subtype'	=> array(
									__( 'Widget based footer options', 'avia_framework' ) => array(
											__( 'Default Layout - set in', 'avia_framework' ) . ' ' . THEMENAME . ' > ' . __( 'Footer', 'avia_framework' ) => '',
											__( 'Display the footer widgets & socket', 'avia_framework' )			=> 'all',
											__( 'Display only the footer widgets (no socket)', 'avia_framework' )	=> 'nosocket',
											__( 'Display only the socket (no footer widgets)', 'avia_framework' )	=> 'nofooterwidgets',
											__( 'Don\'t display the socket & footer widgets', 'avia_framework' )	=> 'nofooterarea',
										),
									__( 'Page based Footer options - set in', 'avia_framework' ) . ' ' . THEMENAME . ' > ' . __('Footer','avia_framework') => array(		
											__( 'Use selected page to replace footer and keep socket', 'avia_framework' )	=> 'page_in_footer_socket',
											__( 'Use selected page to replace both footer and socket', 'avia_framework' )	=> 'page_in_footer'
										)
								),
			),
	
			array(
				'slug'		=> 'layout',
				'id'		=> 'conditional_header_footer',
				'type'		=> 'condition',
				'class'		=> 'avia-style', 
				'notice'	=> __( 'These settings are only available for stretched layout', 'avia_framework' ). ' - <a href="' . admin_url( 'admin.php?page=avia#goto_layout' ) .'">' . __( 'Change layout', 'avia_framework' ) . '</a>',
				'condition'	=> array( 'option' => 'color-body_style', 'compare' => 'equals', 'value' => 'stretched' ),
				'nodescription' => true
			),
	
			array(
				'slug'		=> 'layout',
				'name'		=> __( 'Footer Behavior (currently in beta)', 'avia_framework' ),
				'desc'		=> __( 'Select the behavior of the footer when user scrolls the page.', 'avia_framework' ),
				'id'		=> 'footer_behavior',
				'type'		=> 'select',
				'std'		=> '',
				'class'		=> 'avia-style',
				'required'	=> array( 'footer', 'not', 'nofooterarea' ),
				'subtype'	=> array(
									__( 'Default Behavior - set in', 'avia_framework' ) . ' ' . THEMENAME . ' > ' . __( 'Footer', 'avia_framework' ) => '',
									__( 'Scroll with page', 'avia_framework' )				=> 'scroll',
									__( 'Sticky with curtain effect', 'avia_framework' )	=> 'curtain_footer'
								)
			),
	
			array(
				'slug'	=> 'layout',
				'id'	=> 'conditional_header_footer_end',
				'type'	=> 'condition_end', 
				'nodescription' => true
			),
		
			array(
				'slug'		=> 'layout',
				'id'		=> 'conditional_header',
				'type'		=> 'condition',
				'class'		=> 'avia-style', 
				'notice'	=> __( 'These settings are only available for layouts with a main menu placed at the top', 'avia_framework' ). ' - <a href="' . admin_url( 'admin.php?page=avia#goto_layout' ) .'">' . __( 'Change layout', 'avia_framework' ) . '</a>',
				'condition'	=> array( 'option' => 'header_position', 'compare' => 'equal_or_empty', 'value' => 'header_top' ),
				'nodescription' => true
			),
        
			array(
				'slug'		=> 'layout',
				'name'		=> __( 'Title Bar Settings', 'avia_framework' ),
				'desc'		=> __( 'Display the Title Bar with Page Title and Breadcrumb Navigation?', 'avia_framework' ),
				'id'		=> 'header_title_bar',
				'type'		=> 'select',
				'std'		=> '',
				'class'		=> 'avia-style',
				'subtype'	=> array( 
									__( 'Default Layout - set in', 'avia_framework') . ' ' . THEMENAME . ' > ' . __( 'Header', 'avia_framework' ) => '',
									__( 'Display title and breadcrumbs', 'avia_framework' )	=> 'title_bar_breadcrumb',
									__( 'Display only title', 'avia_framework' )			=> 'title_bar',
									__( 'Display only breadcrumbs', 'avia_framework' )		=> 'breadcrumbs_only',
									__( 'Hide both', 'avia_framework' )						=> 'hidden_title_bar'
								)
			),
        
			array(
				'slug'		=> 'layout',
				'id'		=> 'conditional_header2',
				'type'		=> 'condition',
				'class'		=> 'avia-style', 
				'notice'	=> __( 'Only available if the logo is not', 'avia_framework' ) . ' <a href="'.admin_url('admin.php?page=avia#goto_header') . '"> ' . __( 'below the menu', 'avia_framework' ).'</a>',
				'condition'	=> array( 'option' => 'header_layout', 'compare' => 'contains', 'value' => 'top_nav_header' ),
				'nodescription' => true
			),
        
			array(
				'slug'		=> 'layout',
				'name'		=> __( 'Header visibility and transparency', 'avia_framework' ),
				'desc'		=> __( 'Several options to change the header transparency and visibility on this page.', 'avia_framework' ),
				'id'		=> 'header_transparency',
				'type'		=> 'select',
				'std'		=> '',
				'class'		=> 'avia-style',
				'subtype'	=> array( 
									__( 'No transparency', 'avia_framework')				=> '',
									__( 'Transparent Header', 'avia_framework')				=> 'header_transparent',
									__( 'Transparent Header with border', 'avia_framework')	=> 'header_transparent header_with_border',
									__( 'Transparent & Glassy Header', 'avia_framework')	=> 'header_transparent header_glassy ',
									__( 'Header is invisible and appears once the users scrolls down', 'avia_framework') => 'header_transparent header_scrolldown ',
									__( 'Hide Header on this page', 'avia_framework' )		=> 'header_transparent header_hidden ',
								)
			),
        
			array(
				'slug'	=> 'layout',
				'id'	=> 'conditional_header2_end',
				'type'	=> 'condition_end', 
				'nodescription' => true
			),
        
			array(
				'slug'	=> 'layout',
				'id'	=> 'conditional_header_end',
				'type'	=> 'condition_end', 
				'nodescription' => true
			),

			array(
				'slug'		=> 'hierarchy',
				'name'		=> __('Breadcrumb parent page','avia_framework'),
				'desc'		=> __('Select a parent page for this entry. If no page is selected the theme will use session data to build the breadcrumb.','avia_framework'),
				'id'		=> 'breadcrumb_parent',
				'type'		=> 'select',
				'std'		=> '',
				'subtype'	=> 'page',
				'with_first' => true,
				'class' => 'avia-style'
			)

);




/**
 * @used_by:		enfold\functions-enfold.php		avia_add_hide_featured_image_select()					10
 * @used_by:		enfold\config-gutenberg\class-avia-gutenberg.php										20
 * @used_by:		enfold\config-woocommerce\admin-options.php  avia_woocommerce_product_options()			500
 * @used_by:		enfold\functions-enfold.php		av_builder_meta_box_elements_content()					10000
 */
$elements = apply_filters( 'avf_builder_elements', $elements );




/*
array(

        'slug'  => 'avia_builder',
        'name'  => 'Layout',
        'desc'  => 'Select the desired Page layout',
        'id'    => 'layout',
        'type'  => 'radio',
        'class' => 'image_radio image_radio_layout',
        'std'   => 'fullwidth',
        'options' => array( 'default'       => 'Default layout',
                            'sidebar_left'  => 'Left Sidebar',
                            'sidebar_right' => 'Right Sidebar',
                            'fullwidth'     => 'No Sidebar'
        ),

        'images' => array(  'default'       => AviaBuilder::$path['imagesURL'].'layout-slideshow.png',
                            'sidebar_left'  => AviaBuilder::$path['imagesURL'].'layout-left.png',
                            'sidebar_right' => AviaBuilder::$path['imagesURL'].'layout-right.png',
                            'fullwidth'     => AviaBuilder::$path['imagesURL'].'layout-fullwidth.png',
        ),
    ),
*/
